/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.template.support;

import java.util.Map;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.template.support.NoticeTemplateAdapter;

public class SimpleNoticeTemplateAdapter
implements NoticeTemplateAdapter {
    public static final String ADAPTER_KEY = "SIMPLE";
    public static final String DEFAULT_PREFIX = "${";
    public static final String DEFAULT_SUFFIX = "}";
    private final String prefix;
    private final String suffix;

    public SimpleNoticeTemplateAdapter() {
        this(DEFAULT_PREFIX, DEFAULT_SUFFIX);
    }

    public SimpleNoticeTemplateAdapter(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String adapterKey() {
        return ADAPTER_KEY;
    }

    @Override
    public boolean support(String contentTemplate) {
        return contentTemplate.contains(this.prefix) && contentTemplate.contains(this.suffix);
    }

    @Override
    public String format(String contentTemplate, Map<String, String> params) {
        String template = contentTemplate;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = StringUtils.trimToNull((String)entry.getKey());
            if (key == null) continue;
            String value = entry.getValue();
            template = template.replace(this.prefix + key + this.suffix, value);
        }
        return template;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

