/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.template.support.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.CharArrayWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import net.guerlab.sms.core.exception.SmsException;
import net.guerlab.sms.template.support.NoticeTemplateAdapter;
import net.guerlab.sms.template.support.freemarker.InternalTemplateLoader;
import net.guerlab.sms.template.support.freemarker.loader.FreeMarkerTemplateLoader;

public class FreeMarkerNoticeTemplateAdapter
implements NoticeTemplateAdapter {
    public static final String ADAPTER_KEY = "FREEMARKER";
    private static final InternalTemplateLoader loader;
    private final Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public FreeMarkerNoticeTemplateAdapter() {
        this.configuration.setDefaultEncoding(StandardCharsets.UTF_8.displayName());
        this.configuration.setTemplateLoader((TemplateLoader)loader);
        this.configuration.setLocale(loader.getLocale());
    }

    public static void addTemplateLoader(FreeMarkerTemplateLoader<?> loader) {
        FreeMarkerNoticeTemplateAdapter.loader.addLoader(loader);
    }

    public String adapterKey() {
        return ADAPTER_KEY;
    }

    public boolean support(String contentTemplate) {
        return true;
    }

    public String format(String contentTemplate, Map<String, String> params) {
        try {
            Template template = this.configuration.getTemplate(contentTemplate);
            CharArrayWriter writer = new CharArrayWriter();
            template.process(params, (Writer)writer);
            return writer.toString().trim();
        }
        catch (Exception e) {
            throw new SmsException((Throwable)e);
        }
    }

    static {
        Locale locale = Locale.getDefault();
        loader = new InternalTemplateLoader(locale);
    }
}

