/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.template.support.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.guerlab.sms.core.exception.SmsException;
import net.guerlab.sms.template.support.freemarker.loader.FreeMarkerTemplateLoader;
import net.guerlab.sms.template.support.freemarker.loader.StringFreeMarkerTemplateLoader;

final class InternalTemplateLoader
implements TemplateLoader {
    private final Locale locale;
    private final String localeName;
    private final FreeMarkerTemplateLoader<?> defaultLoader;
    private final Map<String, FreeMarkerTemplateLoader<?>> loaderMap = new HashMap();

    InternalTemplateLoader(Locale locale) {
        this.locale = locale;
        this.localeName = "_" + locale;
        this.defaultLoader = StringFreeMarkerTemplateLoader.INSTANCE;
        this.loaderMap.put(this.defaultLoader.protocol(), this.defaultLoader);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addLoader(FreeMarkerTemplateLoader<?> loader) {
        this.loaderMap.put(loader.protocol(), loader);
    }

    public Object findTemplateSource(String name) throws IOException {
        FreeMarkerTemplateLoader<?> loader;
        String key = name;
        int index = name.lastIndexOf(".");
        if (index > 0) {
            String sub = name.substring(0, index);
            if (sub.endsWith(this.localeName)) {
                sub = sub.substring(0, sub.length() - this.localeName.length());
            }
            key = sub + name.substring(index);
        } else if (name.endsWith(this.localeName)) {
            key = name.substring(0, name.length() - this.localeName.length());
        }
        index = key.indexOf(":");
        String protocol = null;
        String path = key;
        if (index > 0) {
            protocol = key.substring(0, index);
            path = key.substring(index + FreeMarkerTemplateLoader.PROTOCOL_DIVISION_LENGTH);
        }
        FreeMarkerTemplateLoader<?> freeMarkerTemplateLoader = loader = protocol == null ? this.defaultLoader : this.loaderMap.get(protocol);
        if (loader == null) {
            throw new SmsException("un support load protocol: " + protocol);
        }
        return loader.findTemplateSource(path);
    }

    public long getLastModified(Object templateSource) {
        for (FreeMarkerTemplateLoader<?> loader : this.loaderMap.values()) {
            if (!loader.accept(templateSource)) continue;
            return loader.getLastModified(templateSource);
        }
        throw new SmsException("not support template source, type is " + templateSource.getClass());
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        for (FreeMarkerTemplateLoader<?> loader : this.loaderMap.values()) {
            if (!loader.accept(templateSource)) continue;
            return loader.getReader(templateSource, encoding);
        }
        throw new SmsException("not support template source, type is " + templateSource.getClass());
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        for (FreeMarkerTemplateLoader<?> loader : this.loaderMap.values()) {
            if (!loader.accept(templateSource)) continue;
            loader.closeTemplateSource(templateSource);
        }
    }
}

