/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.spring.redis.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.sms.server.repository.VerificationCodeRepository;
import net.guerlab.sms.server.spring.autoconfigure.SmsAutoConfiguration;
import net.guerlab.sms.server.spring.autoconfigure.VerificationCodeAutoConfiguration;
import net.guerlab.sms.server.spring.redis.properties.RedisProperties;
import net.guerlab.sms.server.spring.redis.repository.VerificationCodeRedisRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@AutoConfigureAfter(value={SmsAutoConfiguration.class})
@AutoConfigureBefore(value={VerificationCodeAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class VerificationCodeRedisRepositoryAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeRedisRepositoryAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={VerificationCodeRepository.class})
    @ConditionalOnBean(value={StringRedisTemplate.class})
    public VerificationCodeRepository verificationCodeRedisRepository(RedisProperties properties, StringRedisTemplate redisTemplate, ObjectMapper objectMapper) {
        VerificationCodeRedisRepository repository = new VerificationCodeRedisRepository(properties, redisTemplate, objectMapper);
        log.debug("create VerificationCodeRepository: Redis");
        return repository;
    }
}

