/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.entity.VerificationCode;
import net.guerlab.sms.server.properties.RedisProperties;
import net.guerlab.sms.server.repository.VerificationCodeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={RedisProperties.class})
public class VerificationCodeRedisRepository
implements VerificationCodeRepository {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeRedisRepository.class);
    private RedisProperties properties;
    private RedisTemplate<String, String> redisTemplate;
    private ObjectMapper objectMapper;

    @Autowired
    public void setProperties(RedisProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public VerificationCode findOne(String phone, @Nullable String identificationCode) {
        String key = this.key(phone, identificationCode);
        String data = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)data)) {
            log.debug("json data is empty for key: {}", (Object)key);
            return null;
        }
        try {
            return (VerificationCode)this.objectMapper.readValue(data, VerificationCode.class);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void save(VerificationCode verificationCode) {
        String value;
        String key = this.key(verificationCode.getPhone(), verificationCode.getIdentificationCode());
        ValueOperations operations = this.redisTemplate.opsForValue();
        LocalDateTime expirationTime = verificationCode.getExpirationTime();
        try {
            value = this.objectMapper.writeValueAsString((Object)verificationCode);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (expirationTime == null) {
            operations.set((Object)key, (Object)value);
        } else {
            long now = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
            long end = expirationTime.toEpochSecond(ZoneOffset.UTC);
            long timeout = end - now;
            operations.set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void delete(String phone, @Nullable String identificationCode) {
        this.redisTemplate.delete((Object)this.key(phone, identificationCode));
    }

    private String key(String phone, @Nullable String identificationCode) {
        String keyPrefix = StringUtils.trimToNull((String)this.properties.getKeyPrefix());
        String tempIdentificationCode = StringUtils.trimToNull((String)identificationCode);
        StringBuilder keyBuilder = new StringBuilder();
        if (keyPrefix != null) {
            keyBuilder.append(keyPrefix);
            keyBuilder.append("_");
        }
        keyBuilder.append(StringUtils.trimToNull((String)phone));
        if (tempIdentificationCode != null) {
            keyBuilder.append("_");
            keyBuilder.append(tempIdentificationCode);
        }
        return keyBuilder.toString();
    }
}

