/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sms.server.entity.VerificationCode;
import net.guerlab.sms.server.properties.RedisProperties;
import net.guerlab.sms.server.repository.IVerificationCodeRepository;
import net.guerlab.sms.server.repository.VerificationCodeMemoryRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={RedisProperties.class})
public class VerificationCodeRedisRepository
implements IVerificationCodeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationCodeMemoryRepository.class);
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.of("+0");
    @Autowired
    private RedisProperties properties;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private ObjectMapper objectMapper;

    public VerificationCode findOne(String phone, String identificationCode) {
        String key = this.key(phone, identificationCode);
        ValueOperations operations = this.redisTemplate.opsForValue();
        String json = (String)operations.get((Object)key);
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.debug("json data is empty");
            return null;
        }
        try {
            return (VerificationCode)this.objectMapper.readValue(json, VerificationCode.class);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void save(VerificationCode verificationCode) {
        String value;
        String key = this.key(verificationCode.getPhone(), verificationCode.getIdentificationCode());
        ValueOperations operations = this.redisTemplate.opsForValue();
        LocalDateTime expirationTime = verificationCode.getExpirationTime();
        try {
            value = this.objectMapper.writeValueAsString((Object)verificationCode);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationException((Throwable)e);
        }
        if (expirationTime == null) {
            operations.set((Object)key, (Object)value);
        } else {
            long now = LocalDateTime.now().toEpochSecond(ZONE_OFFSET);
            long end = expirationTime.toEpochSecond(ZONE_OFFSET);
            long timeout = end - now;
            operations.set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void delete(String phone, String identificationCode) {
        this.redisTemplate.delete((Object)this.key(phone, identificationCode));
    }

    private String key(String phone, String identificationCode) {
        String tempPrefix = StringUtils.trimToNull((String)this.properties.getKeyPrefix());
        String prefix = tempPrefix == null ? "" : tempPrefix + "_";
        if (StringUtils.isBlank((CharSequence)identificationCode)) {
            return prefix + phone;
        }
        return prefix + phone + "_" + identificationCode;
    }
}

