/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.server.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sms.server.entity.VerificationCode;
import net.guerlab.sms.server.repository.IVerificationCodeRepository;
import net.guerlab.sms.server.repository.VerificationCodeMemoryRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Repository;

@Repository
public class VerificationCodeRedisRepository
implements IVerificationCodeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerificationCodeMemoryRepository.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private ObjectMapper objectMapper;

    public VerificationCode findOne(String phone, String identificationCode) {
        String key = this.key(phone, identificationCode);
        ValueOperations operations = this.redisTemplate.opsForValue();
        String json = (String)operations.get((Object)key);
        if (StringUtils.isBlank((CharSequence)json)) {
            LOGGER.debug("json data is empty");
            return null;
        }
        VerificationCode verificationCode = null;
        try {
            verificationCode = (VerificationCode)this.objectMapper.readValue(json, VerificationCode.class);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return verificationCode;
    }

    public void save(VerificationCode verificationCode) {
        String key = this.key(verificationCode.getPhone(), verificationCode.getIdentificationCode());
        ValueOperations operations = this.redisTemplate.opsForValue();
        LocalDateTime expirationTime = verificationCode.getExpirationTime();
        String value = null;
        try {
            value = this.objectMapper.writeValueAsString((Object)verificationCode);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new ApplicationException((Throwable)e);
        }
        if (expirationTime == null) {
            operations.set((Object)key, (Object)value);
        } else {
            int timeout = expirationTime.getSecond() - LocalDateTime.now().getSecond();
            operations.set((Object)key, (Object)value, (long)timeout, TimeUnit.SECONDS);
        }
    }

    public void delete(String phone, String identificationCode) {
        this.redisTemplate.delete((Object)this.key(phone, identificationCode));
    }

    private String key(String phone, String identificationCode) {
        if (StringUtils.isBlank((CharSequence)identificationCode)) {
            return phone;
        }
        return phone + "_" + identificationCode;
    }
}

