/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.qcloud;

import net.guerlab.sms.qcloud.QCloudProperties;
import net.guerlab.sms.qcloud.QCloudSendHandler;
import net.guerlab.sms.server.loadbalancer.SmsSenderLoadBalancer;
import net.guerlab.sms.server.spring.autoconfigure.SmsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={QCloudProperties.class})
@AutoConfigureAfter(value={SmsAutoConfiguration.class})
public class QCloudAutoConfigure {
    @Bean
    @Conditional(value={QCloudSendHandlerCondition.class})
    @ConditionalOnBean(value={SmsSenderLoadBalancer.class})
    public QCloudSendHandler qcloudSendHandler(QCloudProperties properties, SmsSenderLoadBalancer loadbalancer, ApplicationEventPublisher eventPublisher) {
        QCloudSendHandler handler = new QCloudSendHandler(properties, eventPublisher);
        loadbalancer.addTarget((Object)handler, Boolean.valueOf(true));
        loadbalancer.setWeight((Object)handler, properties.getWeight());
        return handler;
    }

    public static class QCloudSendHandlerCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enable = (Boolean)context.getEnvironment().getProperty("sms.qcloud.enable", Boolean.class);
            return enable == null || enable != false;
        }
    }
}

