/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.qcloud;

import com.github.qcloudsms.SmsMultiSender;
import com.github.qcloudsms.SmsMultiSenderResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.qcloud.QCloudProperties;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class QCloudSendHandler
extends AbstractSendHandler<QCloudProperties> {
    private static final Logger log = LoggerFactory.getLogger(QCloudSendHandler.class);
    private static final String DEFAULT_NATION_CODE = "86";
    private final SmsMultiSender sender;

    public QCloudSendHandler(QCloudProperties properties, ApplicationEventPublisher eventPublisher) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.sender = new SmsMultiSender(properties.getAppId(), properties.getAppkey());
    }

    public String getChannelName() {
        return "qCloud";
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        Integer templateId = (Integer)((QCloudProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            return false;
        }
        List paramsOrder = ((QCloudProperties)this.properties).getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        HashMap<String, ArrayList<String>> phoneMap = new HashMap<String, ArrayList<String>>(phones.size());
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            if (phone.startsWith("+")) {
                Object[] values = phone.split(" ");
                if (values.length == 1) {
                    this.getList(phoneMap, DEFAULT_NATION_CODE).add(phone);
                    continue;
                }
                String nationCode = values[0];
                String phoneNumber = StringUtils.join((Object[])values, (String)"", (int)1, (int)values.length);
                this.getList(phoneMap, nationCode).add(phoneNumber);
                continue;
            }
            this.getList(phoneMap, DEFAULT_NATION_CODE).add(phone);
        }
        boolean result = phoneMap.entrySet().parallelStream().allMatch(entry -> this.send0(templateId, params, (String)entry.getKey(), (ArrayList)entry.getValue()));
        if (result) {
            this.publishSendEndEvent(noticeData, phones);
        }
        return result;
    }

    private Collection<String> getList(Map<String, ArrayList<String>> phoneMap, String nationCode) {
        return phoneMap.computeIfAbsent(nationCode, k -> new ArrayList());
    }

    private boolean send0(int templateId, ArrayList<String> params, String nationCode, ArrayList<String> phones) {
        try {
            SmsMultiSenderResult result = this.sender.sendWithParam(nationCode, phones, templateId, params, ((QCloudProperties)this.properties).getSmsSign(), "", "");
            if (result.result == 0) {
                return true;
            }
            log.debug("send fail[code={}, errMsg={}]", (Object)result.result, (Object)result.errMsg);
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

