/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.qcloud;

import com.github.qcloudsms.SmsMultiSender;
import com.github.qcloudsms.SmsMultiSenderResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.handler.SendHandler;
import net.guerlab.sms.qcloud.QCloudProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudSendHandler
implements SendHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QCloudSendHandler.class);
    private static final String DEFAULT_NATION_CODE = "86";
    private QCloudProperties properties;
    private SmsMultiSender sender;

    public QCloudSendHandler(QCloudProperties properties) {
        this.properties = properties;
        this.initClient();
    }

    private void initClient() {
        int appid = this.properties.getAppId();
        String appkey = this.properties.getAppkey();
        this.sender = new SmsMultiSender(appid, appkey);
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        Integer templateId = this.properties.getTemplates(type);
        if (templateId == null) {
            LOGGER.debug("templateId invalid");
            return false;
        }
        List<String> paramsOrder = this.properties.getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(paramsOrder)) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        HashMap<String, ArrayList<String>> phoneMap = new HashMap<String, ArrayList<String>>();
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            if (phone.startsWith("+")) {
                Object[] values = phone.split(" ");
                if (values.length == 1) {
                    this.getList(phoneMap, DEFAULT_NATION_CODE).add(phone);
                    continue;
                }
                String nationCode = values[0];
                String phoneNumber = StringUtils.join((Object[])values, (String)"", (int)1, (int)values.length);
                this.getList(phoneMap, nationCode).add(phoneNumber);
                continue;
            }
            this.getList(phoneMap, DEFAULT_NATION_CODE).add(phone);
        }
        return phoneMap.entrySet().parallelStream().map(entry -> this.send0(templateId, params, (String)entry.getKey(), (ArrayList)entry.getValue())).filter(v -> v == false).count() == 0L;
    }

    private Collection<String> getList(Map<String, ArrayList<String>> phoneMap, String nationCode) {
        ArrayList<String> list = phoneMap.get(nationCode);
        if (list == null) {
            list = new ArrayList();
            phoneMap.put(nationCode, list);
        }
        return list;
    }

    private boolean send0(int templateId, ArrayList<String> params, String nationCode, ArrayList<String> phones) {
        try {
            SmsMultiSenderResult result = this.sender.sendWithParam(nationCode, phones, templateId, params, this.properties.getSmsSign(), "", "");
            if (result.result == 0) {
                return true;
            }
            LOGGER.debug("send fail[code={}, errMsg={}]", (Object)result.result, (Object)result.errMsg);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

