/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.jpush;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.jpush.JPushProperties;
import net.guerlab.sms.jpush.MultiRecipient;
import net.guerlab.sms.jpush.MultiResult;
import net.guerlab.sms.jpush.Recipient;
import net.guerlab.sms.jpush.Result;
import net.guerlab.sms.jpush.SingleResult;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class JPushSendHandler
extends AbstractSendHandler<JPushProperties> {
    private static final Logger log = LoggerFactory.getLogger(JPushSendHandler.class);
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public JPushSendHandler(JPushProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper, RestTemplate restTemplate) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplate;
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        Integer templateId = (Integer)((JPushProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            return false;
        }
        String[] phoneArray = phones.toArray(new String[0]);
        try {
            Result result;
            if (phoneArray.length > 1) {
                MultiRecipient data = new MultiRecipient();
                data.setSignId(((JPushProperties)this.properties).getSignId());
                data.setTempId(templateId);
                ArrayList<Recipient> recipients = new ArrayList<Recipient>(phoneArray.length);
                for (String phone : phoneArray) {
                    Recipient recipient = new Recipient();
                    recipient.setMobile(phone);
                    recipient.setTempPara(noticeData.getParams());
                    recipients.add(recipient);
                }
                data.setRecipients(recipients);
                result = this.getResponse("https://api.sms.jpush.cn/v1/messages/batch", data, MultiResult.class);
            } else {
                Recipient data = new Recipient();
                data.setMobile(phoneArray[0]);
                data.setSignId(((JPushProperties)this.properties).getSignId());
                data.setTempId(templateId);
                data.setTempPara(noticeData.getParams());
                result = this.getResponse("https://api.sms.jpush.cn/v1/messages", data, SingleResult.class);
            }
            if (result.getError() == null) {
                this.publishSendSuccessEvent(noticeData, phones);
                return true;
            }
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(result.getError().getMessage()));
            return false;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
    }

    private <T> T getResponse(String uri, Object requestData, Class<T> clazz) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Authorization", "Basic " + this.getSign());
        HttpEntity httpEntity = new HttpEntity((Object)this.objectMapper.writeValueAsString(requestData), (MultiValueMap)headers);
        ResponseEntity httpResponse = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        if (httpResponse.getBody() == null) {
            log.debug("response body ie null");
            throw new SendFailedException("response body ie null");
        }
        String responseContent = (String)httpResponse.getBody();
        log.debug("responseContent: {}", (Object)responseContent);
        return (T)this.objectMapper.readValue(responseContent, clazz);
    }

    private String getSign() {
        String origin = ((JPushProperties)this.properties).getAppKey() + ":" + ((JPushProperties)this.properties).getMasterSecret();
        return Base64.getEncoder().encodeToString(origin.getBytes(StandardCharsets.UTF_8));
    }

    public String getChannelName() {
        return "jPush";
    }
}

