/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.jpush;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.jpush.JPushProperties;
import net.guerlab.sms.jpush.MultiRecipient;
import net.guerlab.sms.jpush.MultiResult;
import net.guerlab.sms.jpush.Recipient;
import net.guerlab.sms.jpush.Result;
import net.guerlab.sms.jpush.SingleResult;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class JPushSendHandler
extends AbstractSendHandler<JPushProperties> {
    private static final Logger log = LoggerFactory.getLogger(JPushSendHandler.class);
    private final ObjectMapper objectMapper;
    private final CloseableHttpClient client;

    public JPushSendHandler(JPushProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.client = this.buildHttpclient();
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        Integer templateId = (Integer)((JPushProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            return false;
        }
        String[] phoneArray = phones.toArray(new String[0]);
        try {
            Result result;
            if (phoneArray.length > 1) {
                MultiRecipient data = new MultiRecipient();
                data.setSignId(((JPushProperties)this.properties).getSignId());
                data.setTempId(templateId);
                ArrayList<Recipient> recipients = new ArrayList<Recipient>(phoneArray.length);
                for (String phone : phoneArray) {
                    Recipient recipient = new Recipient();
                    recipient.setMobile(phone);
                    recipient.setTempPara(noticeData.getParams());
                    recipients.add(recipient);
                }
                data.setRecipients(recipients);
                result = this.getResponse("https://api.sms.jpush.cn/v1/messages/batch", data, MultiResult.class);
            } else {
                Recipient data = new Recipient();
                data.setMobile(phoneArray[0]);
                data.setSignId(((JPushProperties)this.properties).getSignId());
                data.setTempId(templateId);
                data.setTempPara(noticeData.getParams());
                result = this.getResponse("https://api.sms.jpush.cn/v1/messages", data, SingleResult.class);
            }
            if (result.getError() == null) {
                this.publishSendSuccessEvent(noticeData, phones);
                return true;
            }
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(result.getError().getMessage()));
            return false;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
    }

    private <T> T getResponse(String uri, Object requestData, Class<T> clazz) throws Exception {
        CloseableHttpResponse response = this.client.execute(RequestBuilder.create((String)"POST").setUri(uri).addHeader("Content-Type", "application/json").addHeader("Authorization", "Basic " + this.getSign()).setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString(requestData))).build());
        String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
        log.debug("responseContent: {}", (Object)responseContent);
        return (T)this.objectMapper.readValue(responseContent, clazz);
    }

    private String getSign() {
        String origin = ((JPushProperties)this.properties).getAppKey() + ":" + ((JPushProperties)this.properties).getMasterSecret();
        return Base64.getEncoder().encodeToString(origin.getBytes(StandardCharsets.UTF_8));
    }

    private CloseableHttpClient buildHttpclient() {
        try {
            TrustStrategy trustStrategy = (x509CertChain, authType) -> true;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(trustStrategy).build();
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public String getChannelName() {
        return "jPush";
    }
}

