/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.huaweicloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendClientException;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.huaweicloud.HuaWeiCloudProperties;
import net.guerlab.sms.huaweicloud.HuaWeiCloudResult;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HuaWeiCloudSendHandler
extends AbstractSendHandler<HuaWeiCloudProperties> {
    private static final Logger log = LoggerFactory.getLogger(HuaWeiCloudSendHandler.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
    private static final String DEFAULT_NATION_CODE = "+86";
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public HuaWeiCloudSendHandler(HuaWeiCloudProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper, RestTemplate restTemplate) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplate;
    }

    @Nullable
    private static String buildTemplateParas(@Nullable Collection<String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        boolean firstParam = true;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (String param : params) {
            if (!firstParam) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(param);
            builder.append("\"");
            firstParam = false;
        }
        builder.append("]");
        return builder.toString();
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((HuaWeiCloudProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            return false;
        }
        List paramsOrder = ((HuaWeiCloudProperties)this.properties).getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        StringBuilder receiverBuilder = new StringBuilder();
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            if (!phone.startsWith("+")) {
                phone = DEFAULT_NATION_CODE + phone;
            }
            receiverBuilder.append(phone);
            receiverBuilder.append(",");
        }
        String receiver = receiverBuilder.substring(0, receiverBuilder.length() - 1);
        String templateParas = HuaWeiCloudSendHandler.buildTemplateParas(params);
        String wsseHeader = this.buildWsseHeader();
        MultiValueMap<String, String> body = this.buildRequestBody(receiver, templateId, templateParas);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("Authorization", AUTH_HEADER_VALUE);
        headers.set("X-WSSE", wsseHeader);
        try {
            ResponseEntity httpResponse = this.restTemplate.exchange(((HuaWeiCloudProperties)this.properties).getUri(), HttpMethod.POST, new HttpEntity(body, (MultiValueMap)headers), String.class, new Object[0]);
            if (httpResponse.getBody() == null) {
                log.debug("response body ie null");
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("response body ie null"));
                return false;
            }
            String responseContent = (String)httpResponse.getBody();
            log.debug("responseContent: {}", (Object)responseContent);
            HuaWeiCloudResult result = (HuaWeiCloudResult)this.objectMapper.readValue(responseContent, HuaWeiCloudResult.class);
            boolean succeed = "000000".equals(result.getCode());
            if (succeed) {
                this.publishSendSuccessEvent(noticeData, phones);
            } else {
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(result.getDescription()));
            }
            return succeed;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
    }

    private MultiValueMap<String, String> buildRequestBody(String receiver, String templateId, @Nullable String templateParas) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{receiver, templateId})) {
            throw new SendFailedException("buildRequestBody(): receiver or templateId is null.");
        }
        String signature = StringUtils.trimToNull((String)((HuaWeiCloudProperties)this.properties).getSignature());
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"from", (Object)((HuaWeiCloudProperties)this.properties).getSender());
        body.add((Object)"to", (Object)receiver);
        body.add((Object)"templateId", (Object)templateId);
        if (templateParas != null) {
            body.add((Object)"templateParas", (Object)templateParas);
        }
        if (signature != null) {
            body.add((Object)"signature", (Object)signature);
        }
        return body;
    }

    private String buildWsseHeader() {
        String appKey = ((HuaWeiCloudProperties)this.properties).getAppKey();
        String appSecret = ((HuaWeiCloudProperties)this.properties).getAppSecret();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appKey, appSecret})) {
            throw new SendClientException("buildWsseHeader(): appKey or appSecret is null.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String str = nonce + time + appSecret;
            digest.update(str.getBytes(StandardCharsets.UTF_8));
            String hexDigest = HuaWeiCloudSendHandler.byte2Hex(digest.digest());
            String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
            return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
        }
        catch (Exception e) {
            throw new SendClientException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getChannelName() {
        return "huaweiCloud";
    }
}

