/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.huaweicloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendClientException;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.huaweicloud.HuaWeiCloudProperties;
import net.guerlab.sms.huaweicloud.HuaWeiCloudResult;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class HuaWeiCloudSendHandler
extends AbstractSendHandler<HuaWeiCloudProperties> {
    private static final Logger log = LoggerFactory.getLogger(HuaWeiCloudSendHandler.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
    private static final String DEFAULT_NATION_CODE = "+86";
    private final ObjectMapper objectMapper;
    private final CloseableHttpClient client;

    public HuaWeiCloudSendHandler(HuaWeiCloudProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.client = this.buildHttpclient();
    }

    private static String buildTemplateParas(Collection<String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        boolean firstParam = true;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (String param : params) {
            if (!firstParam) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(param);
            builder.append("\"");
            firstParam = false;
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((HuaWeiCloudProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            return false;
        }
        List paramsOrder = ((HuaWeiCloudProperties)this.properties).getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        StringBuilder receiverBuilder = new StringBuilder();
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            if (!phone.startsWith("+")) {
                phone = DEFAULT_NATION_CODE + phone;
            }
            receiverBuilder.append(phone);
            receiverBuilder.append(",");
        }
        String receiver = receiverBuilder.substring(0, receiverBuilder.length() - 1);
        String templateParas = HuaWeiCloudSendHandler.buildTemplateParas(params);
        String wsseHeader = this.buildWsseHeader();
        String body = this.buildRequestBody(receiver, templateId, templateParas);
        try {
            CloseableHttpResponse response = this.client.execute(RequestBuilder.create((String)"POST").setUri(((HuaWeiCloudProperties)this.properties).getUri()).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Authorization", AUTH_HEADER_VALUE).addHeader("X-WSSE", wsseHeader).setEntity((HttpEntity)new StringEntity(body)).build());
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            log.debug("responseContent: {}", (Object)responseContent);
            HuaWeiCloudResult result = (HuaWeiCloudResult)this.objectMapper.readValue(responseContent, HuaWeiCloudResult.class);
            boolean succeed = "000000".equals(result.getCode());
            if (succeed) {
                this.publishSendSuccessEvent(noticeData, phones);
            } else {
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(result.getDescription()));
            }
            return succeed;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
    }

    private CloseableHttpClient buildHttpclient() {
        try {
            TrustStrategy trustStrategy = (x509CertChain, authType) -> true;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(trustStrategy).build();
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private String buildRequestBody(String receiver, String templateId, String templateParas) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{receiver, templateId})) {
            throw new SendFailedException("buildRequestBody(): receiver or templateId is null.");
        }
        String signature = StringUtils.trimToNull((String)((HuaWeiCloudProperties)this.properties).getSignature());
        ArrayList<BasicNameValuePair> keyValues = new ArrayList<BasicNameValuePair>();
        keyValues.add(new BasicNameValuePair("from", ((HuaWeiCloudProperties)this.properties).getSender()));
        keyValues.add(new BasicNameValuePair("to", receiver));
        keyValues.add(new BasicNameValuePair("templateId", templateId));
        if (templateParas != null) {
            keyValues.add(new BasicNameValuePair("templateParas", templateParas));
        }
        if (signature != null) {
            keyValues.add(new BasicNameValuePair("signature", signature));
        }
        return URLEncodedUtils.format(keyValues, (Charset)StandardCharsets.UTF_8);
    }

    private String buildWsseHeader() {
        String appKey = ((HuaWeiCloudProperties)this.properties).getAppKey();
        String appSecret = ((HuaWeiCloudProperties)this.properties).getAppSecret();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appKey, appSecret})) {
            throw new SendClientException("buildWsseHeader(): appKey or appSecret is null.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] passwordDigest = DigestUtils.sha256((String)(nonce + time + appSecret));
        String hexDigest = Hex.encodeHexString((byte[])passwordDigest);
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }

    public String getChannelName() {
        return "huaweiCloud";
    }
}

