/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.huaweicloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.sms.huaweicloud.HuaWeiCloudProperties;
import net.guerlab.sms.huaweicloud.HuaWeiCloudSendHandler;
import net.guerlab.sms.server.loadbalancer.SmsSenderLoadBalancer;
import net.guerlab.sms.server.spring.autoconfigure.SmsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={HuaWeiCloudProperties.class})
@AutoConfigureAfter(value={SmsAutoConfiguration.class})
public class HuaWeiCloudAutoConfigure {
    @Bean
    @Conditional(value={HuaWeiCloudSendHandlerCondition.class})
    @ConditionalOnBean(value={SmsSenderLoadBalancer.class})
    public HuaWeiCloudSendHandler huaWeiCloudSendHandler(HuaWeiCloudProperties properties, ObjectMapper objectMapper, SmsSenderLoadBalancer loadbalancer, ApplicationEventPublisher eventPublisher, RestTemplate restTemplate) {
        HuaWeiCloudSendHandler handler = new HuaWeiCloudSendHandler(properties, eventPublisher, objectMapper, restTemplate);
        loadbalancer.addTarget((Object)handler, Boolean.valueOf(true));
        loadbalancer.setWeight((Object)handler, properties.getWeight());
        return handler;
    }

    public static class HuaWeiCloudSendHandlerCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enable = (Boolean)context.getEnvironment().getProperty("sms.huawei.enable", Boolean.class);
            return enable == null || enable != false;
        }
    }
}

