/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.chinamobile;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.guerlab.sms.chinamobile.ChinaMobileProperties;
import net.guerlab.sms.chinamobile.ChinaMobileResult;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ChinaMobileSendHandler
extends AbstractSendHandler<ChinaMobileProperties> {
    private static final Logger log = LoggerFactory.getLogger(ChinaMobileSendHandler.class);
    private static final String BODY_TEMPLATE = "{\"ecName\":\"%s\",\"apId\":\"%s\",\"templateId\":\"%s\",\"mobiles\":\"%s\",\"params\":\"%s\",\"sign\":\"%s\",\"addSerial\":\"\",\"mac\":\"%s\"}";
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public ChinaMobileSendHandler(ChinaMobileProperties properties, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper, RestTemplate restTemplate) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        this.objectMapper = objectMapper;
        this.restTemplate = restTemplate;
    }

    private static String buildTemplateParas(Collection<String> params) {
        if (params == null || params.isEmpty()) {
            return "[\"\"]";
        }
        boolean firstParam = true;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (String param : params) {
            if (!firstParam) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(param);
            builder.append("\"");
            firstParam = false;
        }
        builder.append("]");
        return builder.toString();
    }

    private static String buildMac(String ecName, String apId, String secretKey, String templateId, String mobiles, String params, String sign) {
        String origin = ecName + apId + secretKey + templateId + mobiles + params + sign;
        return DigestUtils.md5DigestAsHex((byte[])origin.getBytes(StandardCharsets.UTF_8));
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((ChinaMobileProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("templateId invalid"));
            return false;
        }
        List paramsOrder = ((ChinaMobileProperties)this.properties).getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        StringBuilder receiverBuilder = new StringBuilder();
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            receiverBuilder.append(phone.trim());
            receiverBuilder.append(",");
        }
        String mobiles = receiverBuilder.substring(0, receiverBuilder.length() - 1);
        String paramsString = ChinaMobileSendHandler.buildTemplateParas(params);
        String body = this.buildRequestBody(mobiles, templateId, paramsString);
        try {
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)new HttpHeaders());
            ResponseEntity httpResponse = this.restTemplate.exchange(((ChinaMobileProperties)this.properties).getUri(), HttpMethod.POST, httpEntity, String.class, new Object[0]);
            if (httpResponse.getBody() == null) {
                log.debug("response body ie null");
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException("response body ie null"));
                return false;
            }
            String responseContent = (String)httpResponse.getBody();
            log.debug("responseContent: {}", (Object)responseContent);
            ChinaMobileResult result = (ChinaMobileResult)this.objectMapper.readValue(responseContent, ChinaMobileResult.class);
            boolean succeed = "success".equals(result.getRspcod());
            if (succeed) {
                this.publishSendSuccessEvent(noticeData, phones);
            } else {
                this.publishSendFailEvent(noticeData, phones, (Throwable)new SendFailedException(result.getRspcod()));
            }
            return succeed;
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            this.publishSendFailEvent(noticeData, phones, e);
            return false;
        }
    }

    private String buildRequestBody(String mobiles, String templateId, String paramsString) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mobiles, templateId})) {
            throw new SendFailedException("buildRequestBody(): mobiles or templateId is null.");
        }
        String ecName = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getEcName());
        String apId = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getApId());
        String secretKey = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getSecretKey());
        String sign = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getSign());
        String mac = ChinaMobileSendHandler.buildMac(ecName, apId, secretKey, templateId, mobiles, paramsString, sign);
        String body = String.format(BODY_TEMPLATE, ecName, apId, templateId, mobiles, paramsString.replace("\"", "\\\""), sign, mac);
        return new String(Base64.getEncoder().encode(body.getBytes(StandardCharsets.UTF_8)));
    }

    public String getChannelName() {
        return "chinaMobile";
    }
}

