/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.chinamobile;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.sms.chinamobile.ChinaMobileProperties;
import net.guerlab.sms.chinamobile.ChinaMobileSendHandler;
import net.guerlab.sms.server.autoconfigure.SmsConfiguration;
import net.guerlab.sms.server.loadbalancer.SmsSenderLoadBalancer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={ChinaMobileProperties.class})
@AutoConfigureAfter(value={SmsConfiguration.class})
public class ChinaMobileAutoConfigure {
    @Bean
    @Conditional(value={ChinaMobileSendHandlerCondition.class})
    @ConditionalOnBean(value={SmsSenderLoadBalancer.class})
    public ChinaMobileSendHandler huaWeiCloudSendHandler(ChinaMobileProperties properties, ObjectMapper objectMapper, SmsSenderLoadBalancer loadbalancer, ApplicationEventPublisher eventPublisher) {
        ChinaMobileSendHandler handler = new ChinaMobileSendHandler(properties, eventPublisher, objectMapper);
        loadbalancer.addTarget((Object)handler, Boolean.valueOf(true));
        loadbalancer.setWeight((Object)handler, properties.getWeight());
        return handler;
    }

    public static class ChinaMobileSendHandlerCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean enable = (Boolean)context.getEnvironment().getProperty("sms.chinamobile.enable", Boolean.class);
            return enable == null || enable != false;
        }
    }
}

