/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.chinamobile;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.guerlab.sms.chinamobile.ChinaMobileProperties;
import net.guerlab.sms.chinamobile.ChinaMobileResult;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.exception.SendFailedException;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChinaMobileSendHandler
extends AbstractSendHandler<ChinaMobileProperties> {
    private static final Logger log = LoggerFactory.getLogger(ChinaMobileSendHandler.class);
    private static final String BODY_TEMPLATE = "{\"ecName\":\"%s\",\"apId\":\"%s\",\"templateId\":\"%s\",\"mobiles\":\"%s\",\"params\":\"%s\",\"sign\":\"%s\",\"addSerial\":\"\",\"mac\":\"%s\"}";
    private final ObjectMapper objectMapper;
    private final CloseableHttpClient client;

    public ChinaMobileSendHandler(ChinaMobileProperties properties, ObjectMapper objectMapper) {
        super((AbstractHandlerProperties)properties);
        this.objectMapper = objectMapper;
        this.client = this.buildHttpclient();
    }

    private static String buildTemplateParas(Collection<String> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        boolean firstParam = true;
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (String param : params) {
            if (!firstParam) {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(param);
            builder.append("\"");
            firstParam = false;
        }
        builder.append("]");
        return builder.toString();
    }

    private static String buildMac(String ecName, String apId, String secretKey, String templateId, String mobiles, String params, String sign) {
        String origin = ecName + apId + secretKey + templateId + mobiles + params + sign;
        return DigestUtils.md5Hex((String)origin);
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((ChinaMobileProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            return false;
        }
        List paramsOrder = ((ChinaMobileProperties)this.properties).getParamsOrder(type);
        ArrayList<String> params = new ArrayList<String>();
        if (!paramsOrder.isEmpty()) {
            Map paramMap = noticeData.getParams();
            for (String paramName : paramsOrder) {
                String paramValue = (String)paramMap.get(paramName);
                params.add(paramValue);
            }
        }
        StringBuilder receiverBuilder = new StringBuilder();
        for (String phone : phones) {
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            receiverBuilder.append(phone.trim());
            receiverBuilder.append(",");
        }
        String mobiles = receiverBuilder.substring(0, receiverBuilder.length() - 1);
        String paramsString = ChinaMobileSendHandler.buildTemplateParas(params);
        String body = this.buildRequestBody(mobiles, templateId, paramsString);
        try {
            CloseableHttpResponse response = this.client.execute(RequestBuilder.create((String)"POST").setUri(((ChinaMobileProperties)this.properties).getUri()).setEntity((HttpEntity)new StringEntity(body)).build());
            String responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            log.debug("responseContent: {}", (Object)responseContent);
            ChinaMobileResult result = (ChinaMobileResult)this.objectMapper.readValue(responseContent, ChinaMobileResult.class);
            return "success".equals(result.getRspcod());
        }
        catch (Exception e) {
            log.debug(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private CloseableHttpClient buildHttpclient() {
        try {
            TrustStrategy trustStrategy = (x509CertChain, authType) -> true;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(trustStrategy).build();
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private String buildRequestBody(String mobiles, String templateId, String paramsString) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{mobiles, templateId})) {
            throw new SendFailedException("buildRequestBody(): mobiles or templateId is null.");
        }
        String ecName = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getEcName());
        String apId = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getApId());
        String secretKey = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getSecretKey());
        String sign = StringUtils.trimToNull((String)((ChinaMobileProperties)this.properties).getSign());
        String mac = ChinaMobileSendHandler.buildMac(ecName, apId, secretKey, templateId, mobiles, paramsString, sign);
        String body = String.format(BODY_TEMPLATE, ecName, apId, templateId, mobiles, paramsString.replace("\"", "\\\""), sign, mac);
        return Base64.encodeBase64String((byte[])body.getBytes(StandardCharsets.UTF_8));
    }
}

