/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.sms.baiducloud;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.sms.SmsClient;
import com.baidubce.services.sms.SmsClientConfiguration;
import com.baidubce.services.sms.model.SendMessageV3Request;
import com.baidubce.services.sms.model.SendMessageV3Response;
import java.util.Collection;
import net.guerlab.sms.baiducloud.BaiduCloudProperties;
import net.guerlab.sms.core.domain.NoticeData;
import net.guerlab.sms.core.utils.StringUtils;
import net.guerlab.sms.server.handler.AbstractSendHandler;
import net.guerlab.sms.server.properties.AbstractHandlerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class BaiduCloudSendHandler
extends AbstractSendHandler<BaiduCloudProperties> {
    private static final Logger log = LoggerFactory.getLogger(BaiduCloudSendHandler.class);
    private final SmsClient client;

    public BaiduCloudSendHandler(BaiduCloudProperties properties, ApplicationEventPublisher eventPublisher) {
        super((AbstractHandlerProperties)properties, eventPublisher);
        SmsClientConfiguration config = new SmsClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(properties.getAccessKeyId(), properties.getSecretAccessKey()));
        config.setEndpoint(properties.getEndpoint());
        this.client = new SmsClient(config);
    }

    public String getChannelName() {
        return "baiduCloud";
    }

    public boolean send(NoticeData noticeData, Collection<String> phones) {
        String type = noticeData.getType();
        String templateId = (String)((BaiduCloudProperties)this.properties).getTemplates(type);
        if (templateId == null) {
            log.debug("templateId invalid");
            return false;
        }
        SendMessageV3Request request = new SendMessageV3Request();
        request.setMobile(StringUtils.join(phones, (String)","));
        request.setSignatureId(((BaiduCloudProperties)this.properties).getSignatureId());
        request.setTemplate(templateId);
        request.setContentVar(noticeData.getParams());
        SendMessageV3Response response = this.client.sendMessage(request);
        if (response == null) {
            log.debug("send fail: not response");
            return false;
        }
        if (!response.isSuccess()) {
            log.debug("send fail: {}", (Object)response.getCode());
            return false;
        }
        this.publishSendEndEvent(noticeData, phones);
        return true;
    }
}

