/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.smart.platform.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.auth.factory.TokenFactory;
import net.guerlab.smart.platform.auth.factory.TokenFactoryManager;
import net.guerlab.smart.platform.commons.exception.RefreshTokenInvalidException;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.entity.IWxUserTokenInfo;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.LoginService;
import net.guerlab.smart.wx.service.service.WxUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

public abstract class AbstractWxControlPanelController<LS extends LoginService> {
    protected WxUserService wxUserService;
    protected LS loginService;

    @IgnoreLogin
    @ApiOperation(value="\u767b\u5f55")
    @GetMapping(value={"/{appId}/login/{code}"})
    public LoginResponse login(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="code", required=true) @PathVariable String code, HttpServletRequest request) {
        return this.loginService.login(appId, code, IpUtils.getIp((HttpServletRequest)request), request.getHeader("Referer"), null);
    }

    @IgnoreLogin
    @ApiOperation(value="\u5237\u65b0Token")
    @GetMapping(value={"/{appId}/refreshToken"})
    public LoginResponse refreshToken(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="refreshToken", required=true) @RequestHeader(value="refreshToken") String refreshToken, HttpServletRequest request) {
        String ip = IpUtils.getIp((HttpServletRequest)request);
        TokenFactory tokenFactory = TokenFactoryManager.getTokenFactories(IWxUserTokenInfo.class).stream().filter(factory -> factory.acceptRefreshToken(refreshToken) && factory.acceptIp(ip)).findFirst().orElseThrow(RefreshTokenInvalidException::new);
        IWxUserTokenInfo info = (IWxUserTokenInfo)tokenFactory.parseByRefreshToken(refreshToken);
        if (!Objects.equals(appId, info.getAppId())) {
            throw new RefreshTokenInvalidException();
        }
        return this.loginService.buildLoginResponse(this.wxUserService.findUser(info.getAppId(), info.getOpenId()), tokenFactory, ip);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f")
    @GetMapping
    public WxUserDTO getInfo() {
        return this.findCurrentWxUser().toDTO();
    }

    protected WxUser findCurrentWxUser() {
        WxUser wxUser = this.wxUserService.findUser(WxUserContextHandler.getAppId(), WxUserContextHandler.getOpenId());
        if (wxUser == null) {
            throw new WxUserInvalidException();
        }
        return wxUser;
    }

    @Autowired
    public void setWxUserService(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }

    @Autowired
    public void setLoginService(LS loginService) {
        this.loginService = loginService;
    }
}

