package net.guerlab.smart.wx.web.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 微信用户
 *
 * @author guer
 */
@Data
public class WxUserExcelExport {

    /**
     * openId
     */
    @ExcelProperty(value = "openId", index = 0)
    private String openId;

    /**
     * 应用ID
     */
    @ExcelProperty(value = "应用ID", index = 1)
    private String appId;

    /**
     * 应用名称
     */
    @ExcelProperty(value = "应用名称", index = 2)
    private String appName;

    /**
     * 昵称
     */
    @ExcelProperty(value = "昵称", index = 3)
    private String nickName;

    /**
     * unionId
     */
    @ExcelProperty(value = "unionId", index = 4)
    private String unionId;

    /**
     * 头像地址
     */
    @ExcelProperty(value = "头像地址", index = 5)
    private String avatarUrl;

    /**
     * 注册时间
     */
    @ExcelProperty(value = "注册时间", index = 6)
    private LocalDateTime registryTime;

    /**
     * 最后登录时间
     */
    @ExcelProperty(value = "最后登录时间", index = 7)
    private LocalDateTime lastLoginTime;

    /**
     * 账号是否已激活
     */
    @ExcelProperty(value = "已激活", index = 8)
    private Boolean activated;
}
