package net.guerlab.smart.wx.web.controller.wx.ma;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.wx.auth.WxUserContextHandler;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.domain.MaEncryptedData;
import net.guerlab.smart.wx.core.exception.AppIdInvalidException;
import net.guerlab.smart.wx.service.service.WxMaLoginService;
import net.guerlab.smart.wx.web.controller.AbstractWxControlPanelController;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * 小程序-控制面板
 *
 * @author guer
 */
@Api(tags = "小程序-控制面板")
@RestController("/wx/ma/controlPanel")
@RequestMapping("/wx/ma/controlPanel")
@Transactional(rollbackFor = Exception.class)
public class ControlPanelController extends AbstractWxControlPanelController<WxMaLoginService> {

    @ApiOperation("注册")
    @PostMapping("/{appId}/register")
    public LoginResponse register(@ApiParam(value = "应用ID", required = true) @PathVariable String appId,
            @RequestBody MaEncryptedData encryptedData, HttpServletRequest request) {
        if (!Objects.equals(WxUserContextHandler.getAppId(), appId)) {
            throw new AppIdInvalidException();
        }

        return loginService
                .register(appId, WxUserContextHandler.getOpenId(), encryptedData, null, IpUtils.getIp(request));
    }

    @ApiOperation("获取手机号")
    @PostMapping("/{appId}/getPhoneNumber")
    public Result<String> getPhoneNumber(@ApiParam(value = "应用ID", required = true) @PathVariable String appId,
            @RequestBody MaEncryptedData encryptedData) {
        if (!Objects.equals(WxUserContextHandler.getAppId(), appId)) {
            throw new AppIdInvalidException();
        }

        return new Succeed<>(Succeed.MSG,
                loginService.getPhoneNumber(appId, WxUserContextHandler.getOpenId(), encryptedData));
    }
}
