package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.LoginStatistics;
import net.guerlab.smart.wx.service.entity.RegisterStatistics;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import net.guerlab.smart.wx.service.service.WxUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * 微信用户统计
 *
 * @author guer
 */
@Api(tags = "微信用户统计")
@RestController("/user/wxUserStatistics")
@RequestMapping("/user/wxUserStatistics")
public class WxUserStatisticsController {

    private WxUserService wxUserService;

    private WxUserLoginLogService loginLogService;

    @ApiOperation("注册统计")
    @PostMapping("/registerStatistics")
    public Collection<RegisterStatistics> registerStatistics(@RequestBody WxUserSearchParams searchParams) {
        return wxUserService.selectRegisterStatistics(searchParams);
    }

    @ApiOperation("登录统计")
    @PostMapping("/loginStatistics")
    public Collection<LoginStatistics> loginStatistics(@RequestBody WxUserLoginLogSearchParams searchParams) {
        return loginLogService.selectLoginStatistics(searchParams);
    }

    @Autowired
    public void setWxUserService(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }

    @Autowired
    public void setLoginLogService(WxUserLoginLogService loginLogService) {
        this.loginLogService = loginLogService;
    }
}
