package net.guerlab.smart.wx.web.controller.commons;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.wx.service.service.WxMaContentSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 小程序-内容安全
 *
 * @author guer
 */
@Api(tags = "小程序-内容安全")
@RestController("/commons/wxMaContentSecurity")
@RequestMapping("/commons/wxMaContentSecurity")
public class WxMaContentSecurityController {

    private WxMaContentSecurityService service;

    @ApiOperation("校验一张图片是否含有违法违规内容")
    @PostMapping("/{appId}/checkImage")
    public void checkImage(@ApiParam(value = "应用ID", required = true) @PathVariable String appId,
            @ApiParam(value = "图片网络地址", required = true) @RequestBody String fileUrl) {
        service.checkImage(appId, fileUrl);
    }

    @ApiOperation("检查一段文本是否含有违法违规内容")
    @PostMapping("/{appId}/checkMessage")
    public void checkMessage(@ApiParam(value = "应用ID", required = true) @PathVariable String appId,
            @ApiParam(value = "文本内容", required = true) @RequestBody String msg) {
        service.checkMessage(appId, msg);
    }

    @Autowired
    public void setService(WxMaContentSecurityService service) {
        this.service = service;
    }
}
