package net.guerlab.smart.wx.web.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 签名数据
 *
 * @author guer
 */
@Data
@ApiModel("签名数据")
public class SignatureDTO {

    /**
     * 公众号的唯一标识
     */
    @ApiModelProperty("公众号的唯一标识")
    private String appId;

    /**
     * 生成签名的时间戳
     */
    @ApiModelProperty("生成签名的时间戳")
    private Long timestamp;

    /**
     * 生成签名的随机串
     */
    @ApiModelProperty("生成签名的随机串")
    private String nonceStr;

    /**
     * 签名
     */
    @ApiModelProperty("签名")
    private String signature;

}
