package net.guerlab.smart.wx.web.controller.user;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxCpManagerService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信应用
 *
 * @author guer
 */
@Api(tags = "微信应用")
@RestController("/user/wxApp")
@RequestMapping("/user/wxApp")
public class WxAppController extends BaseController<WxAppDTO, WxApp, WxAppService, WxAppSearchParams, String> {

    protected WxCpManagerService wxCpManagerService;

    protected WxMaManagerService wxMaManagerService;

    protected WxMpManagerService wxMpManagerService;

    private OperationLogApi operationLogApi;

    @Override
    protected ApplicationException nullPointException() {
        return new WxAppInvalidException();
    }

    @Override
    public void copyProperties(WxAppDTO dto, WxApp entity, String id) {
        WxAppType wxAppType = entity.getWxAppType();
        super.copyProperties(dto, entity, id);
        if (id == null) {
            return;
        }
        entity.setAppId(id);
        entity.setWxAppType(wxAppType);
    }

    @ApiOperation("移除Token缓存")
    @PostMapping("/{appId}/removeTokenCache")
    public void removeTokenCache(@ApiParam(value = "appId", required = true) @PathVariable String appId) {
        WxApp wxApp = findOne0(appId);

        switch (wxApp.getWxAppType()) {
            case CP:
                WxCpConfigStorage wxCpConfigStorage = wxCpManagerService.getService(appId).getWxCpConfigStorage();
                wxCpConfigStorage.expireAccessToken();
                wxCpConfigStorage.expireJsapiTicket();
                wxCpConfigStorage.expireAgentJsapiTicket();
                break;
            case MP:
                WxMpConfigStorage wxMpConfigStorage = wxMpManagerService.getService(appId).getWxMpConfigStorage();
                wxMpConfigStorage.expireAccessToken();
                break;
            case MINI_APP:
                WxMaConfig wxMaConfig = wxMaManagerService.getService(appId).getWxMaConfig();
                wxMaConfig.expireAccessToken();
                wxMaConfig.expireCardApiTicket();
                wxMaConfig.expireJsapiTicket();
                break;
            default:
        }

        operationLogApi.add("移除Token缓存", UserContextHandler.getUserId(), wxApp);
    }

    @Override
    public void afterSave(WxApp entity, WxAppDTO dto) {
        operationLogApi.add("添加微信应用", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterUpdate(WxApp entity, WxAppDTO dto) {
        operationLogApi.add("编辑微信应用", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterDelete(WxApp entity) {
        operationLogApi.add("删除微信应用", UserContextHandler.getUserId(), entity.getAppId());
    }

    @Autowired
    public void setWxCpManagerService(WxCpManagerService wxCpManagerService) {
        this.wxCpManagerService = wxCpManagerService;
    }

    @Autowired
    public void setWxMaManagerService(WxMaManagerService wxMaManagerService) {
        this.wxMaManagerService = wxMaManagerService;
    }

    @Autowired
    public void setWxMpManagerService(WxMpManagerService wxMpManagerService) {
        this.wxMpManagerService = wxMpManagerService;
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }

}
