package net.guerlab.smart.wx.web.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 微信小程序订阅消息模板
 *
 * @author guer
 */
@Data
@ApiModel("微信小程序订阅消息模板")
public class WxMaSubscribeTemplateListResult implements Serializable {

    private static final long serialVersionUID = -2780782521447602209L;

    /**
     * 模板列表
     */
    @ApiModelProperty("模板列表")
    private List<TemplateItem> data;

    public static WxMaSubscribeTemplateListResult fromJson(String json) {
        return WxGsonBuilder.create().fromJson(json, WxMaSubscribeTemplateListResult.class);
    }

    /**
     * 模板信息
     *
     * @author guer
     */
    @Data
    @ApiModel("模板信息")
    public static class TemplateItem {

        /**
         * 模板ID
         */
        @ApiModelProperty("模板ID")
        private String priTmplId;

        /**
         * 模板标题
         */
        @ApiModelProperty("模板标题")
        private String title;

        /**
         * 模板内容
         */
        @ApiModelProperty("模板内容")
        private String content;

        /**
         * 示例内容
         */
        @ApiModelProperty("示例内容")
        private String example;

        /**
         * 模板类型
         */
        @ApiModelProperty("模板类型")
        private Integer type;
    }
}
