package net.guerlab.smart.wx.web.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.guerlab.smart.wx.web.enums.UserSyncProcess;

/**
 * 用户同步状态
 *
 * @author guer
 */
@Data
@ApiModel("用户同步状态")
public class UserSyncStatus {

    /**
     * 进程
     */
    @ApiModelProperty("进程")
    private UserSyncProcess process;

    /**
     * 错误信息
     */
    @ApiModelProperty("错误信息")
    private String errorMessage;

    /**
     * 总共
     */
    @ApiModelProperty("总共")
    private int count;

    /**
     * 已完成
     */
    @ApiModelProperty("已完成")
    private int complete;
}
