package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.excel.ExcelUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.smart.wx.core.exception.WxUserLoginLogInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import net.guerlab.smart.wx.web.excel.WxUserLoginLogExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@Api(tags = "微信用户登录记录")
@RestController("/user/wxUserLoginLog")
@RequestMapping("/user/wxUserLoginLog")
public class WxUserLoginLogController
        extends BaseFindController<WxUserLoginLogDTO, WxUserLoginLog, WxUserLoginLogService, WxUserLoginLogSearchParams, Long> {

    private OperationLogApi operationLogApi;

    @Override
    protected ApplicationException nullPointException() {
        return new WxUserLoginLogInvalidException();
    }

    @ApiOperation("导出Excel")
    @GetMapping("/exportExcel")
    public void exportExcel(HttpServletResponse response, WxUserLoginLogSearchParams searchParams) {
        beforeFind(searchParams);
        ExcelUtils.exportExcel(response, getService().selectAll(searchParams), WxUserLoginLogExcelExport.class,
                "WxUserLoginLog-" + System.currentTimeMillis());

        operationLogApi.add("导出微信用户登录记录列表", UserContextHandler.getUserId(), searchParams);
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
