/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.wx.mp;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.basic.auth.annotation.IgnoreLogin;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.smart.wx.web.domain.AuthorizeDTO;
import net.guerlab.smart.wx.web.domain.SignatureDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@IgnoreLogin
@Api(tags={"\u516c\u4f17\u53f7-\u516c\u5171"})
@RestController(value="/wx/mp/commons")
@RequestMapping(value={"/wx/mp/commons"})
public class CommonsController {
    private WxMpManagerService managerService;

    @ApiOperation(value="\u83b7\u53d6jsapi\u7b7e\u540d\u6570\u636e")
    @GetMapping(value={"/{appId}/signature"})
    public SignatureDTO signature(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(hidden=true) @RequestHeader(value="Referer") String url) {
        WxJsapiSignature signature;
        try {
            signature = this.getWxMpService(appId).createJsapiSignature(url);
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
        SignatureDTO signatureDTO = new SignatureDTO();
        signatureDTO.setDebug(true);
        signatureDTO.setAppId(signature.getAppId());
        signatureDTO.setTimestamp(signature.getTimestamp());
        signatureDTO.setNonceStr(signature.getNonceStr());
        signatureDTO.setSignature(signature.getSignature());
        signatureDTO.setJsApiList(SignatureDTO.DEFAULT_JS_API_LIST);
        return signatureDTO;
    }

    @ApiOperation(value="\u6388\u6743\u767b\u9646")
    @GetMapping(value={"/{appId}/authorize"})
    public AuthorizeDTO authorize(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(value="redirectUri", required=true) @RequestParam String redirectUri) {
        String url = this.getWxMpService(appId).oauth2buildAuthorizationUrl(redirectUri, "snsapi_userinfo", "");
        return new AuthorizeDTO(url);
    }

    private WxMpService getWxMpService(String appId) {
        return this.managerService.getService(appId);
    }

    @Autowired
    public void setManagerService(WxMpManagerService managerService) {
        this.managerService = managerService;
    }
}

