/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.user;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxCpManagerService;
import net.guerlab.smart.wx.service.service.WxMaManagerService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.spring.commons.dto.ConvertDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1\u5e94\u7528"})
@RestController(value="/user/wxApp")
@RequestMapping(value={"/user/wxApp"})
public class WxAppController
extends BaseController<WxAppDTO, WxApp, WxAppService, WxAppSearchParams, String> {
    protected WxCpManagerService wxCpManagerService;
    protected WxMaManagerService wxMaManagerService;
    protected WxMpManagerService wxMpManagerService;
    private OperationLogApi operationLogApi;

    protected ApplicationException nullPointException() {
        return new WxAppInvalidException();
    }

    public void copyProperties(WxAppDTO dto, WxApp entity, String id) {
        WxAppType wxAppType = entity.getWxAppType();
        super.copyProperties((Object)dto, (ConvertDTO)entity, (Object)id);
        if (id == null) {
            return;
        }
        entity.setAppId(id);
        entity.setWxAppType(wxAppType);
    }

    @ApiOperation(value="\u79fb\u9664Token\u7f13\u5b58")
    @PostMapping(value={"/{appId}/removeTokenCache"})
    public void removeTokenCache(@ApiParam(value="appId", required=true) @PathVariable String appId) {
        WxApp wxApp = (WxApp)this.findOne0(appId);
        switch (wxApp.getWxAppType()) {
            case CP: {
                WxCpConfigStorage wxCpConfigStorage = this.wxCpManagerService.getService(appId).getWxCpConfigStorage();
                wxCpConfigStorage.expireAccessToken();
                wxCpConfigStorage.expireJsapiTicket();
                wxCpConfigStorage.expireAgentJsapiTicket();
                break;
            }
            case MP: {
                WxMpConfigStorage wxMpConfigStorage = this.wxMpManagerService.getService(appId).getWxMpConfigStorage();
                wxMpConfigStorage.expireAccessToken();
                break;
            }
            case MINI_APP: {
                WxMaConfig wxMaConfig = this.wxMaManagerService.getService(appId).getWxMaConfig();
                wxMaConfig.expireAccessToken();
                wxMaConfig.expireCardApiTicket();
                wxMaConfig.expireJsapiTicket();
                break;
            }
        }
        this.operationLogApi.add("\u79fb\u9664Token\u7f13\u5b58", UserContextHandler.getUserId(), new Object[]{wxApp});
    }

    public void afterSave(WxApp entity, WxAppDTO dto) {
        this.operationLogApi.add("\u6dfb\u52a0\u5fae\u4fe1\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterUpdate(WxApp entity, WxAppDTO dto) {
        this.operationLogApi.add("\u7f16\u8f91\u5fae\u4fe1\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterDelete(WxApp entity) {
        this.operationLogApi.add("\u5220\u9664\u5fae\u4fe1\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity.getAppId()});
    }

    @Autowired
    public void setWxCpManagerService(WxCpManagerService wxCpManagerService) {
        this.wxCpManagerService = wxCpManagerService;
    }

    @Autowired
    public void setWxMaManagerService(WxMaManagerService wxMaManagerService) {
        this.wxMaManagerService = wxMaManagerService;
    }

    @Autowired
    public void setWxMpManagerService(WxMpManagerService wxMpManagerService) {
        this.wxMpManagerService = wxMpManagerService;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

