package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.domain.UserTagDTO;
import net.guerlab.smart.wx.core.exception.UserTagInvalidException;
import net.guerlab.smart.wx.core.searchparams.UserTagSearchParams;
import net.guerlab.smart.wx.service.entity.UserTag;
import net.guerlab.smart.wx.service.service.UserTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户标签
 *
 * @author guer
 */
@Api(tags = "用户标签")
@RestController("/user/userTag")
@RequestMapping("/user/userTag")
public class UserTagController extends BaseController<UserTagDTO, UserTag, UserTagService, UserTagSearchParams, Long> {

    private OperationLogApi operationLogApi;

    @Override
    protected ApplicationException nullPointException() {
        return new UserTagInvalidException();
    }

    @Override
    public void copyProperties(UserTagDTO dto, UserTag entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setTagId(id);
    }

    @Override
    public void afterSave(UserTag entity, UserTagDTO dto) {
        operationLogApi.add("添加用户标签", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterUpdate(UserTag entity, UserTagDTO dto) {
        operationLogApi.add("编辑用户标签", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterDelete(UserTag entity) {
        operationLogApi.add("删除用户标签", UserContextHandler.getUserId(), entity.getTagId());
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }

}
