/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.wx;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1\u7528\u6237"})
@RestController(value="/wx/wxUser")
@RequestMapping(value={"/wx/wxUser"})
public class WxUserController {
    private WxUserService service;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237")
    @GetMapping(value={"/{openId}"})
    public WxUserDTO findOne(@PathVariable String openId) {
        WxUser wxUser = (WxUser)this.service.selectByIdOptional((Object)openId).orElseThrow(WxUserInvalidException::new);
        return this.toDTO(wxUser);
    }

    @ApiOperation(value="\u6839\u636eopenId\u5217\u8868\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/findMap"})
    public Map<String, WxUserDTO> findMap(@RequestBody Collection<String> openIds) {
        if (openIds == null || openIds.isEmpty()) {
            return Collections.emptyMap();
        }
        WxUserSearchParams searchParams = new WxUserSearchParams();
        searchParams.setOpenIds(openIds);
        Collection wxUsers = this.service.selectAll((AbstractSearchParams)searchParams);
        return CollectionUtil.toMap((Collection)wxUsers, WxUser::getOpenId, this::toDTO);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u6570\u91cf")
    @GetMapping(value={"/count"})
    public int findCount(WxUserSearchParams searchParams) {
        return this.service.selectCount((AbstractSearchParams)searchParams);
    }

    private WxUserDTO toDTO(WxUser user) {
        WxUserDTO dto = new WxUserDTO();
        dto.setOpenId(user.getOpenId());
        dto.setNickName(user.getNickName());
        dto.setAvatarUrl(user.getAvatarUrl());
        return dto;
    }

    @Autowired
    public void setService(WxUserService service) {
        this.service = service;
    }
}

