package net.guerlab.smart.wx.web.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@Data
public class WxUserLoginLogExcelExport {

    /**
     * 登录记录ID
     */
    @ExcelProperty(value = "登录记录ID", index = 0)
    private Long loginLogId;

    /**
     * openId
     */
    @ExcelProperty(value = "openId", index = 1)
    private String openId;

    /**
     * 应用ID
     */
    @ExcelProperty(value = "应用ID", index = 2)
    private String appId;

    /**
     * 应用名称
     */
    @ExcelProperty(value = "应用名称", index = 3)
    private String appName;

    /**
     * unionId
     */
    @ExcelProperty(value = "unionId", index = 4)
    private String unionId;

    /**
     * 头像地址
     */
    @ExcelProperty(value = "头像地址", index = 5)
    private String avatarUrl;

    /**
     * 昵称
     */
    @ExcelProperty(value = "昵称", index = 6)
    private String nickName;

    /**
     * 登录时间
     */
    @ExcelProperty(value = "登录时间", index = 7)
    private LocalDateTime loginTime;

    /**
     * 账号是否已激活
     */
    @ExcelProperty(value = "已激活", index = 8)
    private Boolean activated;

    /**
     * 登录IP
     */
    @ExcelProperty(value = "登录IP", index = 9)
    private String ip;

    /**
     * 登录源
     */
    @ExcelProperty(value = "登录源", index = 10)
    private String referer;
}
