package net.guerlab.smart.wx.web.controller.user.wx.mp;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.bean.template.WxMpTemplate;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.message.WxMpTemplateMessageSendRequest;
import net.guerlab.smart.wx.service.controller.mp.AbstractWxMpTemplateMsgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.List;

/**
 * 微信-公众号-模版消息
 *
 * @author guer
 */
@Api(tags = "微信-公众号-模版消息")
@RestController("/user/wx/mp/templateMsg")
@RequestMapping("/user/wx/mp/templateMsg")
public class TemplateMsgController extends AbstractWxMpTemplateMsgController {

    private OperationLogApi operationLogApi;

    @ApiOperation("获取列表")
    @GetMapping("/{appId}/templateList")
    public List<WxMpTemplate> list(@ApiParam(value = "应用ID", required = true) @PathVariable String appId) {
        try {
            return wxMpManagerService.getService(appId).getTemplateMsgService().getAllPrivateTemplate();
        } catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), e, e.getError().getErrorCode());
        }
    }

    @Override
    protected void afterSendMsg(String appId, Collection<String> openIds, WxMpTemplateMessageSendRequest request) {
        operationLogApi.add("发送微信公众号模版消息", UserContextHandler.getUserId(), appId, openIds, request);
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
