/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.user.wx.mp;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.exception.WxMpUserSynchronizingException;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.smart.wx.web.domain.UserSyncStatus;
import net.guerlab.smart.wx.web.enums.UserSyncProcess;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1-\u516c\u4f17\u53f7-\u7528\u6237\u7ba1\u7406"})
@RestController(value="/user/wx/mp/user")
@RequestMapping(value={"/user/wx/mp/user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    private static final int SINGLE_LIMIT = 100;
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(AVAILABLE_PROCESSORS, AVAILABLE_PROCESSORS * 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread thread = new Thread(r);
        thread.setName("async_wx_mp_user");
        return thread;
    });
    private final Map<String, AtomicBoolean> lockMap = new ConcurrentHashMap(8);
    private final Map<String, UserSyncStatus> statusMap = new ConcurrentHashMap(8);
    private WxMpManagerService mpManagerService;
    private WxUserService wxUserService;
    private WxAppService wxAppService;
    private OperationLogApi operationLogApi;

    @ApiOperation(value="\u83b7\u53d6\u540c\u6b65\u7528\u6237\u4fe1\u606f\u8fdb\u5ea6")
    @GetMapping(value={"/{appId}/userSync"})
    public UserSyncStatus getUserSyncStatus(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId) {
        UserSyncStatus status = (UserSyncStatus)this.statusMap.get(appId);
        if (status == null) {
            status = new UserSyncStatus();
            status.setProcess(UserSyncProcess.FREE);
        }
        return status;
    }

    @ApiOperation(value="\u540c\u6b65\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/{appId}/userSync"})
    public void userSync(@ApiParam(value="\u5e94\u7528ID", required=true) @PathVariable String appId) {
        AtomicBoolean flag = this.lockMap.computeIfAbsent(appId, s -> new AtomicBoolean());
        if (!flag.compareAndSet(false, true)) {
            throw new WxMpUserSynchronizingException();
        }
        UserSyncStatus status = this.statusMap.computeIfAbsent(appId, s -> new UserSyncStatus());
        status.setProcess(UserSyncProcess.PENDING_START);
        WxApp wxApp = (WxApp)this.wxAppService.selectByIdOptional((Object)appId).orElseThrow(WxAppInvalidException::new);
        this.executor.execute(() -> {
            try {
                this.userSyncThread(appId, wxApp.getAppName(), status);
            }
            catch (Exception e) {
                log.debug(e.getLocalizedMessage(), (Throwable)e);
                status.setProcess(UserSyncProcess.EXCEPTION);
                status.setErrorMessage(e.getLocalizedMessage());
            }
            finally {
                flag.set(false);
            }
        });
        this.operationLogApi.add("\u540c\u6b65\u516c\u4f17\u53f7\u7528\u6237", UserContextHandler.getUserId(), new Object[]{appId});
    }

    private void userSyncThread(String appId, String appName, UserSyncStatus status) throws Exception {
        WxMpUserService userService = this.mpManagerService.getService(appId).getUserService();
        status.setProcess(UserSyncProcess.GETTING_OPENID_LIST);
        List openIds = this.getOpenIds(userService);
        if (!openIds.isEmpty()) {
            this.userSync(appId, appName, openIds, userService, status);
        }
    }

    private List<String> getOpenIds(WxMpUserService userService) throws Exception {
        boolean hasMore = true;
        String nextOpenid = null;
        ArrayList<String> openIds = new ArrayList<String>();
        while (hasMore) {
            WxMpUserList wxMpUserList = userService.userList(nextOpenid);
            nextOpenid = wxMpUserList.getNextOpenid();
            hasMore = StringUtils.isNotBlank((CharSequence)nextOpenid);
            List tempOpenIds = wxMpUserList.getOpenids();
            if (tempOpenIds.isEmpty()) break;
            openIds.addAll(tempOpenIds);
        }
        return openIds;
    }

    private void userSync(String appId, String appName, List<String> openIds, WxMpUserService userService, UserSyncStatus status) throws Exception {
        int size = openIds.size();
        status.setCount(size);
        status.setProcess(UserSyncProcess.GETTING_USER_DETAIL);
        AtomicInteger complete = new AtomicInteger();
        for (int i = 0; i < size; i += 100) {
            int end = Math.min(i + 100, size) - 1;
            List<String> queryOpenIds = openIds.subList(i, end);
            List wxMpUsers = userService.userInfoList(queryOpenIds);
            for (WxMpUser wxMpUser : wxMpUsers) {
                this.userSyncHandler(appId, appName, wxMpUser);
                status.setComplete(complete.addAndGet(1));
            }
        }
        status.setProcess(UserSyncProcess.FREE);
    }

    private void userSyncHandler(String appId, String appName, WxMpUser user) {
        WxUser wxUser = this.wxUserService.findUser(appId, user.getOpenId());
        if (wxUser == null) {
            wxUser = new WxUser();
            wxUser.setOpenId(user.getOpenId());
            wxUser.setAppId(appId);
            wxUser.setUnionId(user.getUnionId());
            wxUser.setAppName(appName);
            wxUser.setUnionId(user.getUnionId());
            wxUser.setAvatarUrl(user.getHeadImgUrl());
            wxUser.setNickName(user.getNickname());
            this.wxUserService.insertSelective((Object)wxUser);
        } else {
            WxUser update = new WxUser();
            update.setOpenId(wxUser.getOpenId());
            update.setAppId(appId);
            update.setUnionId(user.getUnionId());
            update.setAvatarUrl(user.getHeadImgUrl());
            update.setNickName(user.getNickname());
            update.setVersion(wxUser.getVersion());
            this.wxUserService.updateSelectiveById((Object)update);
        }
    }

    @Autowired
    public void setMpManagerService(WxMpManagerService mpManagerService) {
        this.mpManagerService = mpManagerService;
    }

    @Autowired
    public void setWxUserService(WxUserService wxUserService) {
        this.wxUserService = wxUserService;
    }

    @Autowired
    public void setWxAppService(WxAppService wxAppService) {
        this.wxAppService = wxAppService;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

