/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.spring.commons.dto.ConvertDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1\u5e94\u7528"})
@RestController(value="/user/wxApp")
@RequestMapping(value={"/user/wxApp"})
public class WxAppController
extends BaseController<WxAppDTO, WxApp, WxAppService, WxAppSearchParams, String> {
    private OperationLogApi operationLogApi;

    protected ApplicationException nullPointException() {
        return new WxAppInvalidException();
    }

    public void copyProperties(WxAppDTO dto, WxApp entity, String id) {
        WxAppType wxAppType = entity.getWxAppType();
        super.copyProperties((Object)dto, (ConvertDTO)entity, (Object)id);
        if (id == null) {
            return;
        }
        entity.setAppId(id);
        entity.setWxAppType(wxAppType);
    }

    public void afterSave(WxApp entity, WxAppDTO dto) {
        this.operationLogApi.add("\u6dfb\u52a0\u5fae\u4fe1\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterUpdate(WxApp entity, WxAppDTO dto) {
        this.operationLogApi.add("\u7f16\u8f91\u5fae\u4fe1\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterDelete(WxApp entity) {
        this.operationLogApi.add("\u5220\u9664\u5fae\u4fe1\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity.getAppId()});
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

