package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.wx.core.domain.WxUserLoginLogDTO;
import net.guerlab.smart.wx.core.exception.WxUserLoginLogInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxUserLoginLogSearchParams;
import net.guerlab.smart.wx.service.entity.WxUserLoginLog;
import net.guerlab.smart.wx.service.service.WxUserLoginLogService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信用户登录记录
 *
 * @author guer
 */
@Api(tags = "微信用户登录记录")
@RestController("/user/wxUserLoginLog")
@RequestMapping("/user/wxUserLoginLog")
public class WxUserLoginLogController
        extends BaseFindController<WxUserLoginLogDTO, WxUserLoginLog, WxUserLoginLogService, WxUserLoginLogSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new WxUserLoginLogInvalidException();
    }

}
