/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import net.guerlab.smart.wx.core.domain.UserTagDTO;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.exception.WxUserInvalidException;
import net.guerlab.smart.wx.core.searchparams.UserTagSearchParams;
import net.guerlab.smart.wx.core.searchparams.WxUserSearchParams;
import net.guerlab.smart.wx.service.entity.UserTag;
import net.guerlab.smart.wx.service.entity.UserTagMapping;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.searchparams.UserTagMappingSearchParams;
import net.guerlab.smart.wx.service.service.UserTagMappingService;
import net.guerlab.smart.wx.service.service.UserTagService;
import net.guerlab.smart.wx.service.service.WxUserService;
import net.guerlab.smart.wx.web.domain.SetTagRequestDTO;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u4fe1\u7528\u6237"})
@RestController(value="/user/wxUser")
@RequestMapping(value={"/user/wxUser"})
public class WxUserController
extends BaseFindController<WxUserDTO, WxUser, WxUserService, WxUserSearchParams, String> {
    private UserTagService tagService;
    private UserTagMappingService tagMappingService;

    protected ApplicationException nullPointException() {
        return new WxUserInvalidException();
    }

    public WxUserDTO findOne(String id) {
        WxUserDTO dto = (WxUserDTO)super.findOne((Object)id);
        UserTagMappingSearchParams mappingSearchParams = new UserTagMappingSearchParams();
        mappingSearchParams.setOpenId(dto.getOpenId());
        List tagIds = CollectionUtil.toList((Collection)this.tagMappingService.selectAll((AbstractSearchParams)mappingSearchParams), UserTagMapping::getTagId);
        dto.setTagIds((Collection)tagIds);
        if (!tagIds.isEmpty()) {
            UserTagSearchParams tagSearchParams = new UserTagSearchParams();
            tagSearchParams.setTagIds((Collection)tagIds);
            dto.setTags((Collection)BeanConvertUtils.toList((Collection)this.tagService.selectAll((AbstractSearchParams)tagSearchParams)));
        }
        return dto;
    }

    public ListObject<WxUserDTO> findList(WxUserSearchParams searchParams) {
        if (this.refuseQuery(searchParams)) {
            return ListObject.empty();
        }
        ListObject result = super.findList((AbstractSearchParams)searchParams);
        this.fillTag(result.getList());
        return result;
    }

    public List<WxUserDTO> findAll(WxUserSearchParams searchParams) {
        if (this.refuseQuery(searchParams)) {
            return Collections.emptyList();
        }
        return super.findAll((AbstractSearchParams)searchParams);
    }

    private boolean refuseQuery(WxUserSearchParams searchParams) {
        if (NumberHelper.greaterZero((Number)searchParams.getTagId()) || CollectionUtil.isNotEmpty((Collection)searchParams.getTagIds())) {
            UserTagMappingSearchParams userTagMappingSearchParams = new UserTagMappingSearchParams();
            userTagMappingSearchParams.setTagId(searchParams.getTagId());
            userTagMappingSearchParams.setTagIds(searchParams.getTagIds());
            List openIds = CollectionUtil.toList((Collection)this.tagMappingService.selectAll((AbstractSearchParams)userTagMappingSearchParams), UserTagMapping::getOpenId);
            if (openIds.isEmpty()) {
                return true;
            }
            searchParams.setOpenIds((Collection)openIds);
        }
        return false;
    }

    private void fillTag(Collection<WxUserDTO> users) {
        Map tagMap;
        Map userMap = CollectionUtil.toMap(users, WxUserDTO::getOpenId);
        UserTagMappingSearchParams mappingSearchParams = new UserTagMappingSearchParams();
        mappingSearchParams.setOpenIds(userMap.keySet());
        Collection mappings = this.tagMappingService.selectAll((AbstractSearchParams)mappingSearchParams);
        List tagIds = CollectionUtil.toList((Collection)mappings, UserTagMapping::getTagId);
        if (!tagIds.isEmpty()) {
            UserTagSearchParams tagSearchParams = new UserTagSearchParams();
            tagSearchParams.setTagIds((Collection)tagIds);
            tagMap = CollectionUtil.toMap((Collection)this.tagService.selectAll((AbstractSearchParams)tagSearchParams), UserTag::getTagId, DefaultConvertDTO::toDTO);
        } else {
            tagMap = Collections.emptyMap();
        }
        if (tagMap.isEmpty()) {
            return;
        }
        Map userTagMappingMap = CollectionUtil.group((Collection)mappings, UserTagMapping::getOpenId);
        userTagMappingMap.forEach((openId, userTagMapping) -> {
            WxUserDTO user = (WxUserDTO)userMap.get(openId);
            if (user != null) {
                Collection userTags = userTagMapping.stream().map(UserTagMapping::getTagId).map(tagMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                user.setTags(userTags);
                user.setTagIds((Collection)CollectionUtil.toList((Collection)userTags, UserTagDTO::getTagId));
            }
        });
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    @DeleteMapping(value={"/{appId}/{openId}"})
    public void delete(@ApiParam(value="id", required=true) @PathVariable String appId, @ApiParam(value="id", required=true) @PathVariable String openId) {
        ((WxUserService)this.getService()).delete(appId, openId);
    }

    @ApiOperation(value="\u8bbe\u7f6e\u6807\u7b7e")
    @PostMapping(value={"/{id}/setTags"})
    @Transactional(rollbackFor={Exception.class})
    public void setTags(@ApiParam(value="id", required=true) @PathVariable String id, @RequestBody SetTagRequestDTO request) {
        Collection<Long> tagIds = request.getTagIds();
        UserTagMapping deleteInfo = new UserTagMapping();
        deleteInfo.setOpenId(id);
        this.tagMappingService.delete((Object)deleteInfo);
        if (CollectionUtil.isEmpty(tagIds)) {
            return;
        }
        Collection mappings = tagIds.stream().map(tagId -> new UserTagMapping(id, tagId)).collect(Collectors.toList());
        this.tagMappingService.replaceBatchInsert(mappings);
    }

    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e\u6807\u7b7e")
    @PostMapping(value={"/batchSetTags"})
    public void batchSetTags(@RequestBody SetTagRequestDTO request) {
        Collection<Long> tagIds = request.getTagIds();
        Collection<String> openIds = request.getOpenIds();
        if (CollectionUtil.isEmpty(tagIds) || CollectionUtil.isEmpty(openIds)) {
            return;
        }
        ArrayList<UserTagMapping> mappings = new ArrayList<UserTagMapping>(tagIds.size() * openIds.size());
        for (Long tagId : tagIds) {
            for (String openId : openIds) {
                mappings.add(new UserTagMapping(openId, tagId));
            }
        }
        this.tagMappingService.replaceBatchInsert(mappings);
    }

    @Autowired
    public void setTagService(UserTagService tagService) {
        this.tagService = tagService;
    }

    @Autowired
    public void setTagMappingService(UserTagMappingService tagMappingService) {
        this.tagMappingService = tagMappingService;
    }
}

