package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信应用
 *
 * @author guer
 */
@Api(tags = "微信应用")
@RestController("/user/wxApp")
@RequestMapping("/user/wxApp")
public class WxAppController extends BaseController<WxAppDTO, WxApp, WxAppService, WxAppSearchParams, String> {

    @Override
    protected ApplicationException nullPointException() {
        return new WxAppInvalidException();
    }

    @Override
    public void copyProperties(WxAppDTO dto, WxApp entity, String id) {
        WxAppType wxAppType = entity.getWxAppType();
        super.copyProperties(dto, entity, id);
        if (id == null) {
            return;
        }
        entity.setAppId(id);
        entity.setWxAppType(wxAppType);
    }

}
