package net.guerlab.smart.wx.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.wx.core.domain.UserTagDTO;
import net.guerlab.smart.wx.core.exception.UserTagInvalidException;
import net.guerlab.smart.wx.core.searchparams.UserTagSearchParams;
import net.guerlab.smart.wx.service.entity.UserTag;
import net.guerlab.smart.wx.service.service.UserTagService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户标签
 *
 * @author guer
 */
@Api(tags = "用户标签")
@RestController("/user/userTag")
@RequestMapping("/user/userTag")
public class UserTagController extends BaseController<UserTagDTO, UserTag, UserTagService, UserTagSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new UserTagInvalidException();
    }

    @Override
    public void copyProperties(UserTagDTO dto, UserTag entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setTagId(id);
    }

}
