/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.stream.binders;

import lombok.Data;
import net.guerlab.smart.wx.core.domain.WxAppDTO;

/**
 * 微信应用变更消息
 *
 * @author guer
 */
@Data
public class WxAppChangeMessage {

    /**
     * appId
     */
    private String appId;

    /**
     * 删除标志
     */
    private boolean deleteFlag;

    /**
     * 微信应用
     */
    private WxAppDTO app;
}
