package net.guerlab.smart.wx.stream.binders;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.messaging.SubscribableChannel;

/**
 * 微信应用变更消息订阅者
 *
 * @author guer
 */
public interface WxAppChangeSubscriberChannel {

    /**
     * binding名称
     */
    String NAME = "wx_app_change_input";

    /**
     * 构造微信应用变更消息订阅者
     *
     * @return 微信应用变更消息订阅者
     */
    @Input(NAME)
    SubscribableChannel input();
}
