package net.guerlab.smart.wx.stream.binders;

import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;

/**
 * 微信应用变更消息发送者
 *
 * @author guer
 */
public interface WxAppChangeSenderChannel {

    /**
     * binding名称
     */
    @SuppressWarnings("WeakerAccess")
    String NAME = "wx_app_change_output";

    /**
     * 构造微信应用变更消息发送者
     *
     * @return 微信应用变更消息发送者
     */
    @Output(NAME)
    MessageChannel output();
}
