/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.exception.WxAppInvalidException;
import net.guerlab.smart.wx.mp.spring.storage.WxMpRedisTemplateConfigStorage;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.smart.wx.stream.binders.WxAppChangeMessage;
import net.guerlab.smart.wx.stream.binders.WxAppChangeSubscriberChannel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={WxAppChangeSubscriberChannel.class})
public class WxMpManagerServiceImpl
implements WxMpManagerService {
    private final Lock initLock = new ReentrantLock();
    private WxMpService service;
    private WxAppService wxAppService;
    private RedisTemplate<String, String> redisTemplate;

    @StreamListener(value="wx_app_change_input")
    public void wxAppChangeMessageHandler(Message<WxAppChangeMessage> message) {
        WxAppChangeMessage payload = (WxAppChangeMessage)message.getPayload();
        this.initLock.lock();
        try {
            if (this.service != null) {
                this.service.removeConfigStorage(payload.getAppId());
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WxMpService getService(String appId) {
        if ((appId = StringUtils.trimToNull((String)appId)) == null) {
            return null;
        }
        if (this.service == null) {
            this.initLock.lock();
            try {
                ConcurrentHashMap<String, WxMpConfigStorage> configStorageMap = new ConcurrentHashMap<String, WxMpConfigStorage>(8);
                configStorageMap.put(appId, this.buildConfigStorage(appId));
                this.service = new WxMpServiceImpl();
                this.service.setMultiConfigStorages(configStorageMap, appId);
                WxMpService wxMpService = this.service;
                return wxMpService;
            }
            finally {
                this.initLock.unlock();
            }
        }
        if (this.service.switchover(appId)) {
            return this.service;
        }
        this.service.addConfigStorage(appId, this.buildConfigStorage(appId));
        return this.service.switchoverTo(appId);
    }

    private WxMpConfigStorage buildConfigStorage(String appId) {
        WxApp wxApp = (WxApp)((Object)this.wxAppService.selectById((Serializable)((Object)appId)));
        if (wxApp == null || wxApp.getWxAppType() != WxAppType.MP) {
            throw new WxAppInvalidException();
        }
        WxMpRedisTemplateConfigStorage storage = new WxMpRedisTemplateConfigStorage(this.redisTemplate);
        storage.setAppId(wxApp.getAppId());
        storage.setSecret(wxApp.getSecret());
        storage.setToken(wxApp.getToken());
        storage.setAesKey(wxApp.getAesKey());
        return storage;
    }

    @Autowired
    public void setWxAppService(WxAppService wxAppService) {
        this.wxAppService = wxAppService;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

