/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.time.LocalDateTime;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.platform.auth.factory.TokenFactory;
import net.guerlab.smart.wx.core.domain.LoginResponse;
import net.guerlab.smart.wx.core.entity.IWxUserTokenInfo;
import net.guerlab.smart.wx.core.exception.CodeInvalidException;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.entity.WxUser;
import net.guerlab.smart.wx.service.service.WxMpLoginService;
import net.guerlab.smart.wx.service.service.WxMpManagerService;
import net.guerlab.smart.wx.service.service.impl.AbstractWxLoginServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMpLoginServiceImpl
extends AbstractWxLoginServiceImpl
implements WxMpLoginService {
    private WxMpManagerService managerService;

    @Override
    public LoginResponse login(String appId, String code, String ip, String referer, TokenFactory<IWxUserTokenInfo> tokenFactory) {
        WxMpUser wxMpUser;
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new CodeInvalidException();
        }
        WxApp wxApp = this.getWxApp(appId);
        WxMpService wxMpService = this.getWxMpService(appId);
        try {
            WxMpOAuth2AccessToken oAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
            wxMpUser = wxMpService.oauth2getUserInfo(oAuth2AccessToken, "zh_CN");
        }
        catch (WxErrorException e) {
            throw new ApplicationException(e.getError().getErrorMsg(), (Throwable)e, e.getError().getErrorCode());
        }
        String unionId = wxMpUser.getUnionId();
        String openId = wxMpUser.getOpenId();
        WxUser wxUser = this.wxUserService.findUser(appId, openId);
        if (wxUser == null) {
            LocalDateTime now = LocalDateTime.now();
            wxUser = new WxUser();
            wxUser.setOpenId(openId);
            wxUser.setAppId(appId);
            wxUser.setAppName(wxApp.getAppName());
            wxUser.setUnionId(unionId);
            wxUser.setAvatarUrl(wxMpUser.getHeadImgUrl());
            wxUser.setNickName(wxMpUser.getNickname());
            wxUser.setRegistryTime(now);
            wxUser.setLastLoginTime(now);
            wxUser.setActivated(true);
            this.wxUserService.insert((Object)wxUser);
            this.wxUserLoginLogService.addLog(wxUser, ip, referer);
        } else {
            wxUser.setActivated(true);
            this.updateUserInfo(wxUser, openId, unionId, true, ip, referer);
        }
        return this.buildLoginResponse(wxUser, tokenFactory, ip);
    }

    private WxMpService getWxMpService(String appId) {
        return this.managerService.getService(appId);
    }

    @Autowired
    public void setManagerService(WxMpManagerService managerService) {
        this.managerService = managerService;
    }
}

