/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.io.Serializable;
import java.time.LocalDateTime;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.stream.utils.MessageUtils;
import net.guerlab.smart.wx.core.domain.WxAppDTO;
import net.guerlab.smart.wx.core.enums.WxAppType;
import net.guerlab.smart.wx.core.enums.WxMsgDataFormat;
import net.guerlab.smart.wx.core.exception.AgentIdInvalidException;
import net.guerlab.smart.wx.core.exception.AppIdInvalidException;
import net.guerlab.smart.wx.core.exception.AppIdRepeatException;
import net.guerlab.smart.wx.core.exception.CorpIdInvalidException;
import net.guerlab.smart.wx.core.exception.SecretInvalidException;
import net.guerlab.smart.wx.core.exception.WxAppTypeInvalidException;
import net.guerlab.smart.wx.core.searchparams.WxAppSearchParams;
import net.guerlab.smart.wx.core.utils.WxCpUtils;
import net.guerlab.smart.wx.service.entity.WxApp;
import net.guerlab.smart.wx.service.mapper.WxAppMapper;
import net.guerlab.smart.wx.service.service.WxAppService;
import net.guerlab.smart.wx.stream.binders.WxAppChangeMessage;
import net.guerlab.smart.wx.stream.binders.WxAppChangeSenderChannel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={WxAppChangeSenderChannel.class})
public class WxAppServiceImpl
extends BaseServiceImpl<WxApp, String, WxAppMapper, WxAppSearchParams>
implements WxAppService {
    private WxAppChangeSenderChannel wxAppChangeSenderChannel;

    protected void insertBefore(WxApp entity) {
        String appId = StringUtils.trimToNull((String)entity.getAppId());
        String corpId = StringUtils.trimToNull((String)entity.getCorpId());
        Integer agentId = entity.getAgentId();
        String secret = StringUtils.trimToNull((String)entity.getSecret());
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        WxMsgDataFormat msgDataFormat = entity.getMsgDataFormat();
        WxAppType appType = entity.getWxAppType();
        if (appType == WxAppType.CP) {
            if (corpId == null) {
                throw new CorpIdInvalidException();
            }
            if (!NumberHelper.greaterZero((Number)agentId)) {
                throw new AgentIdInvalidException();
            }
            appId = WxCpUtils.buildAppId((String)corpId, (Integer)agentId);
        } else {
            if (appId == null) {
                throw new AppIdInvalidException();
            }
            corpId = appId;
            agentId = WxApp.DEFAULT_AGENT_ID;
        }
        if (secret == null) {
            throw new SecretInvalidException();
        }
        if (appType == null) {
            throw new WxAppTypeInvalidException();
        }
        if (this.selectById((Serializable)((Object)appId)) != null) {
            throw new AppIdRepeatException();
        }
        LocalDateTime now = LocalDateTime.now();
        entity.setAppId(appId);
        entity.setCorpId(corpId);
        entity.setAgentId(agentId);
        entity.setSecret(secret);
        entity.setToken(StringUtils.trimToEmpty((String)entity.getToken()));
        entity.setAesKey(StringUtils.trimToEmpty((String)entity.getAesKey()));
        if (msgDataFormat == null || appType != WxAppType.MINI_APP) {
            entity.setMsgDataFormat(WxMsgDataFormat.XML);
        }
        entity.setAppName(appName != null ? appName : appId);
        if (entity.getEnable() == null) {
            entity.setEnable(true);
        }
        entity.setRemark(StringUtils.trimToEmpty((String)entity.getRemark()));
        entity.setCreateTime(now);
        entity.setUpdateTime(now);
    }

    protected void updateBefore(WxApp entity) {
        if (entity.getWxAppType() != WxAppType.MINI_APP) {
            entity.setMsgDataFormat(null);
        }
    }

    protected void updateAfter(WxApp entity) {
        WxAppChangeMessage message = new WxAppChangeMessage();
        message.setAppId(entity.getAppId());
        message.setApp((WxAppDTO)entity.convert());
        message.setDeleteFlag(false);
        this.notifyChange(message);
    }

    protected void deleteByIdAfter(String id, Boolean force) {
        WxAppChangeMessage message = new WxAppChangeMessage();
        message.setAppId(id);
        message.setDeleteFlag(true);
        this.notifyChange(message);
    }

    protected void deleteAfter(WxAppSearchParams entity, Boolean force) {
        this.deleteByIdAfter(entity.getAppId(), force);
    }

    private void notifyChange(WxAppChangeMessage message) {
        if (message != null) {
            MessageUtils.send((MessageChannel)this.wxAppChangeSenderChannel.output(), (Object)message);
        }
    }

    @Autowired
    public void setWxAppChangeSenderChannel(WxAppChangeSenderChannel wxAppChangeSenderChannel) {
        this.wxAppChangeSenderChannel = wxAppChangeSenderChannel;
    }
}

