/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.wx.service.service.impl;

import java.util.Objects;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.wx.core.exception.UserTagNameInvalidException;
import net.guerlab.smart.wx.core.exception.UserTagNameRepeatException;
import net.guerlab.smart.wx.core.searchparams.UserTagSearchParams;
import net.guerlab.smart.wx.service.entity.UserTag;
import net.guerlab.smart.wx.service.mapper.UserTagMapper;
import net.guerlab.smart.wx.service.service.UserTagService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserTagServiceImpl
extends BaseServiceImpl<UserTag, Long, UserTagMapper, UserTagSearchParams>
implements UserTagService {
    protected void insertBefore(UserTag entity) {
        String tagName = StringUtils.trimToNull((String)entity.getTagName());
        if (tagName == null) {
            throw new UserTagNameInvalidException();
        }
        if (this.selectByName(tagName) != null) {
            throw new UserTagNameRepeatException();
        }
        entity.setTagId(this.sequence.nextId());
        entity.setTagName(tagName);
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void updateBefore(UserTag entity) {
        UserTag other;
        String tagName = StringUtils.trimToNull((String)entity.getTagName());
        if (tagName != null && (other = this.selectByName(tagName)) != null && !Objects.equals(other.getTagId(), entity.getTagId())) {
            throw new UserTagNameRepeatException();
        }
        entity.setTagName(tagName);
    }
}

