/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.wx.core.domain.WxUserDTO;
import net.guerlab.smart.wx.core.entity.IWxUserTokenInfo;
import net.guerlab.spring.commons.dto.Convert;
import org.springframework.beans.BeanUtils;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;

/**
 * 微信用户
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("wx_user")
public class WxUser extends BaseEntity implements Convert<WxUserDTO>, IWxUserTokenInfo {

    /**
     * openId
     */
    @TableId
    private String openId;

    /**
     * 应用ID
     */
    @TableField(value = "appId", updateStrategy = FieldStrategy.NEVER)
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 头像地址
     */
    private String avatarUrl;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 注册时间
     */
    private LocalDateTime registryTime;

    /**
     * 最后登录时间
     */
    private LocalDateTime lastLoginTime;

    /**
     * 账号是否已激活
     */
    private Boolean activated;

    /**
     * 标签ID列表
     */
    @TableField(exist = false)
    private Collection<Long> tagIds;

    /**
     * 标签列表
     */
    @TableField(exist = false)
    private Collection<UserTag> tags;

    @Override
    public WxUserDTO convert() {
        WxUserDTO dto = new WxUserDTO();

        BeanUtils.copyProperties(this, dto);
        dto.setTagIds(tagIds == null ? Collections.emptyList() : tagIds);
        dto.setTags(BeanConvertUtils.toList(tags));

        return dto;
    }
}
