/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.wx.service.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 微信用户标签映射关系
 *
 * @author guer
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("wx_user_tag_mapping")
public class UserTagMapping {

    /**
     * openId
     */
    private String openId;

    /**
     * 标签ID
     */
    private Long tagId;
}
